/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PIHMCStringDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.HMCCommandsTask;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PIDisplayServiceAgentConfig
extends HMCCommandsTask {
    public static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private static final String STATUS_FORMAT = "status";
    private static final String SMTP_SERVER_FORMAT = "smtp_server";
    private static final String SMTP_SERVER_PORT_FORMAT = "smtp_server_port";
    private static final String EMAIL_ADDRESSES_FORMAT = "email_addresses";
    private static final String FTP_TYPE_FORMAT = "type";
    private static final String FTP_HOST_FORMAT = "host";
    private static final String FTP_USER_FORMAT = "user";
    private static final String FTP_PORT_FORMAT = "port";
    private static final String FTP_PASSIVE_FORMAT = "passive";
    private static final String FTP_ADDRSEXCLUDED_FORMAT = "names_excluded";
    private static final String FTP_DIRECTORY_FORMAT = "directory";
    private static final String[] m_custemailKeys = new String[]{"status", "smtp_server", "smtp_server_port", "email_addresses"};
    private static final String[] m_ftpFirewallKeys = new String[]{"type", "host", "user", "port", "passive", "names_excluded"};
    private static final String[] m_ftpOffloadSrvrKeys = new String[]{"status", "host", "directory", "user", "port", "passive"};
    private static final int NUM_VALID_PARMS = 3;
    private static HashMap m_validParms = null;
    private boolean m_header;
    private String m_delimiter;
    private String m_format;
    private boolean m_writeStatus;
    private String[] m_validKeys;
    private String[] m_actualKeys;
    private String m_commandType;

    private PIDisplayServiceAgentConfig(PrintStream printStream, boolean bl) {
        this.m_writeStatus = bl;
        this.m_header = false;
        this.m_delimiter = ",";
        this.m_format = null;
    }

    private void doEmailCommandDisplay() {
        PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.m_validKeys);
        pIHMCStringDataBean.setKeyValue(STATUS_FORMAT, ServiceAgentUtils.getEmailSetting() ? "enabled" : "disabled");
        pIHMCStringDataBean.setKeyValue(SMTP_SERVER_FORMAT, ServiceAgentUtils.getEmailSMTPServer());
        pIHMCStringDataBean.setKeyValue(SMTP_SERVER_PORT_FORMAT, String.valueOf(ServiceAgentUtils.getEmailPort()));
        Map map = ServiceAgentUtils.getEmailList();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ServiceAgentUtils.EmailValueObject emailValueObject = (ServiceAgentUtils.EmailValueObject)entry.getValue();
            if (iterator.hasNext()) {
                stringBuffer.append(emailValueObject.EmailAddress + "/" + emailValueObject.EmailSetting + this.m_delimiter);
                continue;
            }
            stringBuffer.append(emailValueObject.EmailAddress + "/" + emailValueObject.EmailSetting);
        }
        pIHMCStringDataBean.setKeyValue(EMAIL_ADDRESSES_FORMAT, stringBuffer.toString());
        this.taskletOutput.addElement(pIHMCStringDataBean);
    }

    private void doFTPFirewallCommandDisplay() {
        PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.m_validKeys);
        pIHMCStringDataBean.setKeyValue(FTP_TYPE_FORMAT, ServiceAgentUtils.getFtpFirewallType());
        pIHMCStringDataBean.setKeyValue(FTP_HOST_FORMAT, ServiceAgentUtils.getFtpFirewallHostName());
        pIHMCStringDataBean.setKeyValue(FTP_USER_FORMAT, ServiceAgentUtils.getFtpFirewallUserName());
        pIHMCStringDataBean.setKeyValue(FTP_PORT_FORMAT, String.valueOf(ServiceAgentUtils.getFtpFirewallPort()));
        pIHMCStringDataBean.setKeyValue(FTP_PASSIVE_FORMAT, ServiceAgentUtils.getFtpFirewallPassiveMode());
        String string = ServiceAgentUtils.getFtpFirewallExclusionList();
        StringBuffer stringBuffer = new StringBuffer();
        pIHMCStringDataBean.setKeyValue(FTP_ADDRSEXCLUDED_FORMAT, string);
        this.taskletOutput.addElement(pIHMCStringDataBean);
    }

    private void doFTPOffldSrvrCommandDisplay() {
        PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.m_validKeys);
        pIHMCStringDataBean.setKeyValue(STATUS_FORMAT, ServiceAgentUtils.getFtpOffLoadSetting() ? "enabled" : "disabled");
        pIHMCStringDataBean.setKeyValue(FTP_HOST_FORMAT, ServiceAgentUtils.getFtpServerName());
        pIHMCStringDataBean.setKeyValue(FTP_DIRECTORY_FORMAT, ServiceAgentUtils.getFtpServerDirectory());
        pIHMCStringDataBean.setKeyValue(FTP_USER_FORMAT, ServiceAgentUtils.getFtpServerUserName());
        pIHMCStringDataBean.setKeyValue(FTP_PORT_FORMAT, String.valueOf(ServiceAgentUtils.getFtpPort()));
        pIHMCStringDataBean.setKeyValue(FTP_PASSIVE_FORMAT, ServiceAgentUtils.getFtpServerPassiveMode());
        this.taskletOutput.addElement(pIHMCStringDataBean);
    }

    public void performCommand() throws Exception {
        if (this.m_commandType.equals("email")) {
            this.doEmailCommandDisplay();
        } else if (this.m_commandType.equals("ftpfirewall")) {
            this.doFTPFirewallCommandDisplay();
        } else if (this.m_commandType.equals("ftpoffload")) {
            this.doFTPOffldSrvrCommandDisplay();
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_format = (String)hashMap.get("-F");
        this.m_commandType = (String)hashMap.get("-t");
        String string = (String)hashMap.get("--header");
        if (this.m_commandType == null) {
            String[] stringArray = new String[]{"-t"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        this.m_commandType = this.m_commandType.trim();
        if (this.m_commandType.equals("email")) {
            this.m_validKeys = m_custemailKeys;
        } else if (this.m_commandType.equals("ftpfirewall")) {
            this.m_validKeys = m_ftpFirewallKeys;
        } else if (this.m_commandType.equals("ftpoffload")) {
            this.m_validKeys = m_ftpOffloadSrvrKeys;
        } else {
            String[] stringArray = new String[]{"-t"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
        }
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, this.m_validKeys, this.m_validKeys.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            this.m_actualKeys = PICmdOutputUtils.checkKeys(this.m_validKeys, this.m_format, this.m_delimiter);
        } else {
            this.m_actualKeys = this.m_validKeys;
        }
        if (string != null) {
            if (this.m_format == null) {
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_HEADER_PARM", null, null);
            }
            if (string.trim().length() != 0) {
                String[] stringArray = new String[]{"--header"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
            }
            this.m_header = true;
        }
    }

    private static HashMap getValidParms() {
        if (m_validParms == null) {
            m_validParms = new HashMap(7, 0.5f);
            m_validParms.put("-t", null);
            m_validParms.put("-F", null);
            m_validParms.put("--header", null);
        }
        return m_validParms;
    }

    public void printResults(int n, PrintStream printStream) {
        if (n != 0) {
            Enumeration enumeration = this.taskletOutput.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                printStream.println(string);
            }
            return;
        }
        PICmdOutputUtils.printResults(printStream, this.m_writeStatus, this.taskletOutput.elements(), this.m_actualKeys, this.m_delimiter, this.m_header, this.m_format == null);
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        printStream.print('\u0000');
        printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "LSSACFG_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        PIHscUtil.initHscUtil(3);
        PIDisplayServiceAgentConfig pIDisplayServiceAgentConfig = new PIDisplayServiceAgentConfig(printStream, bl);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        try {
            pIDisplayServiceAgentConfig.mapParameters(PIHMCCommandUtils.parseParameters(arrayList, PIDisplayServiceAgentConfig.getValidParms()));
            n = pIDisplayServiceAgentConfig.invokeViaTasklet();
            pIDisplayServiceAgentConfig.printResults(n, printStream);
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                if (bl) {
                    printStream.println(pIHscClientException.getMessage());
                }
            } else {
                pIHscClientException.printStackTrace(System.out);
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR");
                }
                if (bl) {
                    printStream.println(string);
                }
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR");
            if (bl) {
                printStream.println(string);
            }
            n = 1;
        }
        return n;
    }
}

